// 引入 Electron 的 contextBridge 和 ipcRenderer 模块
const { contextBridge, ipcRenderer } = require('electron');

// 通过 contextBridge 向渲染进程暴露一些方法，实现渲染进程和主进程之间的安全通信
contextBridge.exposeInMainWorld('electronAPI', {
    // 向主进程发送最小化窗口的消息
    minimizeWindow: () => ipcRenderer.send('minimize-window'),
    // 向主进程发送切换窗口最大化状态的消息
    toggleMaximizeWindow: () => ipcRenderer.send('toggle-maximize-window'),
    // 向主进程发送关闭窗口的消息
    closeWindow: () => ipcRenderer.send('close-window'),
    // 监听窗口最大化消息，并执行回调函数
    onWindowMaximized: (callback) => ipcRenderer.on('window-maximized', callback),
    // 监听窗口从最大化恢复消息，并执行回调函数
    onWindowUnmaximized: (callback) => ipcRenderer.on('window-unmaximized', callback),
    // // 创建项目
    // projectNew: () => ipcRenderer.invoke('project-new'),
    // // 重命名项目
    // projectRename: (id, name) => ipcRenderer.invoke('project-rename', id, name),
    // 删除项目
    projectDelete: (id) => ipcRenderer.invoke('project-delete', id),
    // 打开当前项目跟文件夹
    openProjectFolder: (CurrentProjectFolder) => ipcRenderer.invoke('open-project-folder', CurrentProjectFolder),
    // 打开当前项目图片素材文件夹
    openProjectFolderImg: (CurrentProjectFolder) => ipcRenderer.invoke('open-project-folder-img', CurrentProjectFolder),
    // 打开指定网页
    openUrl: (url) => ipcRenderer.invoke('open-url', url),
    // // 创建功能逻辑
    // newLogic: (CurrentProjectFolder) => ipcRenderer.invoke('new-logic', CurrentProjectFolder),
    // 删除功能逻辑本地文件
    //deleteLogic: (CurrentProjectId, logic_id) => ipcRenderer.invoke('delete-logic', CurrentProjectId, logic_id),
    // // 重命名功能逻辑
    // renameLogic: (CurrentProjectFolder, CurrentEditLogicFile, name) => ipcRenderer.invoke('rename-logic', CurrentProjectFolder, CurrentEditLogicFile, name),
    // // 移动功能逻辑顺序
    // moveOrderLogic: (CurrentProjectFolder, CurrentEditLogicFile, direction) => ipcRenderer.invoke('move-order-logic', CurrentProjectFolder, CurrentEditLogicFile, direction),
    // 保存功能逻辑代码到相应的文件里
    saveLogic: (CurrentProjectFolder, jsonData, luaData) => ipcRenderer.invoke('save-logic', CurrentProjectFolder, jsonData, luaData),
    // // 保存基本设置
    // saveCore: (CurrentProjectFolder, key, val) => ipcRenderer.invoke('save-core', CurrentProjectFolder, key, val),
    
    // 获取任务功能对应的JSON文件并返回给渲染进程
    getLogicEditorJson: (CurrentProjectId) => ipcRenderer.invoke('get-logic-editor-json', CurrentProjectId),


    // 更新本地文件及数据
    updateLocal: (ProjectId, ProjectData, ProjectLogic) => ipcRenderer.invoke('update-local', ProjectId, ProjectData, ProjectLogic),

    // 确认弹框
    confirmBox: (title, text) => ipcRenderer.invoke('confirm-box', title, text),


    // // 更新项目列表
    // updateProjectList: (data) => ipcRenderer.on('update-project-list', data),
    // // 更新功能逻辑列表
    // updateLogicList: (data) => ipcRenderer.on('update-logic-list', data),
    // // 更新界面预览窗口列表
    // updateUIWinList: (data) => ipcRenderer.on('update-ui-win-list', data),





});